<?php

	/*******
	2008-10-16 - result series function htmlspecialchars option
	2013-07-06 - multi-database edition
	2017-08-02 - odbc > sqlsrv
	2017-09-30 - ReturnDatesAsStrings
	2017-11-07 - add log
	********/
	
	class SQL {
	
		var $DBCount;
	
		var $tablename=NULL;
		var $fieldlist=NULL;
		var $lastsql=NULL;
		var $dontExec=false;
		
		function SQL( $index = 0 ) {
			$this->DBCount 			= count($GLOBALS['MYSQL_config']);
			//$this->DBCount 			= 1;
			$this->connect();
		}
	
		function resultSingleArr($sql, $db = 0, $secure = 1) {
			$result = $this->query($sql, $db);
			$sqlArr = sqlsrv_fetch_array($result, SQLSRV_FETCH_ASSOC);
			sqlsrv_free_stmt($result);
			return $secure ? $this->_secure($sqlArr, $db) : $sqlArr;
		}
	
		function resultManyArr($sql, $db = 0, $secure = 1) {
			$result = $this->query($sql, $db);
			while($row=sqlsrv_fetch_array($result, SQLSRV_FETCH_ASSOC)) {
				$sqlArr[] = $row;
			}
			sqlsrv_free_stmt($result);
			if ( !$sqlArr ) return array();
			return $secure ? $this->_secure($sqlArr, $db) : $sqlArr;
		}
	
		function resultSingleFieldArr($sql, $db = 0, $secure = 1){
			$result = $this->query($sql, $db);
			while($row=sqlsrv_fetch_array($result, SQLSRV_FETCH_ASSOC)) {
				$sqlArr[] = current($row);
			}
			sqlsrv_free_stmt($result);
			if ( !$sqlArr ) return array();
			return $secure ? $this->_secure($sqlArr, $db) : $sqlArr;
		}
	
		function resultValue($sql, $db = 0, $secure = 1) {
			$result = $this->query($sql, $db);
			$sqlArr = sqlsrv_fetch_array($result, SQLSRV_FETCH_ASSOC);
			if ($sqlArr) $value = current($sqlArr);
			sqlsrv_free_stmt($result);
			return $secure ? $this->_secure($value, $db) : $value;
		}
	
		function _secure($data, $db = 0) {
			if (is_array($data)) {
				if (is_array($data[0])) {
					foreach ($data as $key=>$value) $data[$key] = $this->_htmlspecialchars($value, $db);
				} else {
					$data = $this->_htmlspecialchars($data, $db);
				}
			} else {
				$data = is_null($data) ? NULL : $data;
			}
			return $data;
		}
	
		function _htmlspecialchars($data, $db = 0) {
			if (is_array($data)) foreach ($data as $key=>$value) {
				$data[$key] = is_null($value) ? NULL : $value;
			}
			return $data;
		}
		
		function query($sql, $i = 0) {
			// log
			$log = date('r').' '.$_SERVER['REMOTE_ADDR']."\n> ".$sql."\n\n";
			$this->sys_create_file(LOG_SQL_EXPORT.date('Ymd').'.txt', $log, 'a');
			// query
			$result = sqlsrv_query($this->connection_link, $sql);
			if (sqlsrv_errors()) {
				var_dump($sql);
				var_dump(sqlsrv_errors());
				die();
			}
			return $result;
		}
	
		function connect() {
			$MYSQL_config = $GLOBALS['MYSQL_config'];
			$connectionInfo = array( "Database"=>$MYSQL_config['DBname'],
									"UID"=>$MYSQL_config['user'],
									"PWD"=>$MYSQL_config['passwd'],
									"CharacterSet" => "UTF-8",
									'ReturnDatesAsStrings'=>true );
			$this->connection_link = sqlsrv_connect( $MYSQL_config['host'], $connectionInfo);
			if (!$this->connection_link) {
				var_dump(sqlsrv_errors());
				die();
			}
			return $this->connection_link;
		}
		
		function close() {
			sqlsrv_close($this->connection_link);
		}
		
		// orginial sources sql_command_lib.php
		function commandTable($tablename) {
			$this->tablename=$tablename;
		}
		function chgTable($tablename){
			$this->tablename=$tablename;
		}	
			
		function _filterKeys($arr,$filerKeys){
			$rarr=array();
			foreach($filerKeys as $k){
				if($k!="id" && in_array($k,array_keys($arr)))$rarr[$k]=$arr[$k];
			}
			return $rarr;
		}
		
		function _markFieldList(){
			if($this->fieldlist==NULL) $this->fieldlist=$this->listfield();
			return $this->fieldlist;
		}
		
		function _selectString($sqlcmds,$colSql=NULL,$join=NULL){
			$orderCmds = array("WHERE","ORDER","LIMIT");
			
			if( is_null($colSql) ) $colSql="*";
			$cols = explode(",",$colSql);
			$colSql="";
			foreach($cols as $col) $colSql.=$this->tablename.".".$col.", ";
			$colSql=substr($colSql,0,-2);
			
			if ( !is_null($join) ){
				$colSql.=", ";
				$cols=explode(",",$join["col"]);
				foreach($cols as $i=>$col) $colSql.=$join[table].".".$col.", ";
				$colSql=substr($colSql,0,-2);
			}
			
			
			$sql="SELECT $colSql FROM {$this->tablename} ";
			//JOIN
			if ( !is_null($join) ){
				$sql.=$join["join"]." ";
				$sql.=$join["table"]." ON";
				$ons = explode("=",$join["on"]);
				foreach($ons as $i=>$on){
					if(!strpos($on,".")) $ons[$i]=$join["table"].".".$ons[$i];
				}
				$join["on"]=implode("=",$ons);
				$join["on"]=str_replace(":table",$this->tablename,$join["on"]);
				$sql.="({$join[on]})";
			}
	
			foreach($orderCmds as $cmd){
				if(isset($sqlcmds[$cmd])){
					$q=$sqlcmds[$cmd];
					if($cmd=="ORDER")$q=" BY ".$q;
					$sql.=" ".$cmd." ".$q." ";
				}
			}
			
			return $sql;
		}
			
		function _combineSET($datas){
			$sqlSET="";
			foreach($datas as $col=>$value) {
				if ( is_null($value) && !isset($value) && $value === NULL ) {
					$sqlSET.=" $col=NULL,";
				} else {
					$sqlSET.=" $col='$value',";
				}
			}
			$sqlSET=substr($sqlSET,0,-1);
			return $sqlSET;
		}
		
		function listField(){
			$rows=array();
			$result = $this->query("SHOW COLUMNS FROM {$this->tablename}");
			while($row=sqlsrv_fetch_array($result, SQLSRV_FETCH_ASSOC))$rows[]=$row["Field"];
			sqlsrv_free_stmt($result);
			return $rows;
		}
		
		function swapRecord( $id1, $id2 ) {
			$sql="SELECT id, arrange FROM `".$this->tablename."` WHERE id in ('".$id1."','".$id2."')";
			$arr = $this->resultManyArr($sql);
			$arrange_id1	 = $arr[0]["id"];
			$arrange_id2	 = $arr[1]["id"];
			$arrange_1	 = $arr[0]["arrange"];
			$arrange_2	 = $arr[1]["arrange"];
			$type = is_numeric($arrange_1) ? 'int' : 'date';
			if ( $id1 != '' && $id2 != '' ) {	
				if ( $arrange_1 == $arrange_2 ) {
					if ( $type == 'date' ) {
						$arrange_1 = date("YmdHis", mktime(date('H', strtotime($arrange_1)), date('i', strtotime($arrange_1)), date('s', strtotime($arrange_1)), date('m', strtotime($arrange_1)), date('d', strtotime($arrange_1)), date('Y', strtotime($arrange_1))));
						$arrange_2 = date("YmdHis", mktime(date('H', strtotime($arrange_2)), date('i', strtotime($arrange_2)), date('s', strtotime($arrange_2)) + 1, date('m', strtotime($arrange_2)), date('d', strtotime($arrange_2)), date('Y', strtotime($arrange_2))));
					} else {
						$arrange_1 = $arrange_1;
						$arrange_2 = $arrange_1 + 1;
					}
				}
				$this->query("UPDATE `".$this->tablename."` SET arrange='".$arrange_1."' WHERE id='".$id2."'");
				$this->query("UPDATE `".$this->tablename."` SET arrange='".$arrange_2."' WHERE id='".$id1."'");
			}
		}
	
		function insert($datas){
			$datas=$this->_filterKeys($datas,$this->_markFieldList());
			$sql="INSERT INTO {$this->tablename} SET ";
			$sql.=$this->_combineSET($datas);
			$this->lastsql=$sql;
			if(!$this->dontExec) $this->query($sql, $i);
			return sqlsrv_insert_id();
		}
		
		function update($id,$datas,$AND=NULL){
			$datas=$this->_filterKeys($datas,$this->_markFieldList());
			$sql="UPDATE {$this->tablename} SET ";
			$sql.=$this->_combineSET($datas);
			$sql.=" WHERE id='$id' ";
			if( !is_null($AND) ) $AND=" AND ".$AND;
			$sql.=$AND;
			$this->lastsql=$sql;
			if(!$this->dontExec)  $this->query($sql, $i);
			return sqlsrv_rows_affected();
		}
		
		function updates($ids,$datas,$AND=NULL){
			$datas=$this->_filterKeys($datas,$this->_markFieldList());
			$sql="UPDATE {$this->tablename} SET ";
			$sql.=$this->_combineSET($datas);
			$sql.=" WHERE id in '$id' in (".implode(",",$ids).") ";
			if( !is_null($AND) ) $AND=" AND ".$AND;
			$sql.=$AND;
			$this->lastsql=$sql;
			if(!$this->dontExec) $this->query($sql, $i);
			return sqlsrv_rows_affected();
		}
		
		function delete($id,$AND=NULL){
			$sql="DELETE FROM {$this->tablename} WHERE id='$id'";
			if( !is_null($AND) ) $AND=" AND ".$AND;
			$sql.=$AND;
			$this->lastsql=$sql;
			if(!$this->dontExec) $this->query($sql, $i);
			return sqlsrv_rows_affected();
		}
		
		function deletes($ids,$AND=NULL){
			$sql="DELETE FROM {$this->tablename} WHERE id in (".implode(",",$ids).") ";
			if( !is_null($AND) ) $AND=" AND ".$AND;
			$sql.=$AND;
			$this->lastsql=$sql;
			if(!$this->dontExec) $this->query($sql, $i);
			return sqlsrv_rows_affected();
		}
		
		function replace($datas){
			$datas=$this->_filterKeys($datas,$this->_markFieldList());
			$sql="REPLACE INTO {$this->tablename} SET ";
			$sql.=$this->_combineSET($datas);
			if( !is_null($AND) ) $AND=" AND ".$AND;
			$sql.=$AND;
			$this->lastsql=$sql;
			if(!$this->dontExec)  $this->query($sql, $i);
			return sqlsrv_rows_affected();
		}
	
		function leftJoin($tablename,$colSQL=NULL,$onSQL){
			return array("join"=>"LEFT JOIN","table"=>$tablename,"on"=>$onSQL,"col"=>$colSQL);
		}
		
		function innerJoin($tablename,$colSQL=NULL,$onSQL){
			return array("join"=>"INNER JOIN","table"=>$tablename,"on"=>$onSQL,"col"=>$colSQL);
		}
		
		function sys_create_file( $file = 'demo.txt', $data = '', $method = 'w' ) {
			if ($tmpFile = fopen($file, $method)) {
				fwrite($tmpFile, $data);
				fclose($tmpFile);
				return true;
			}
			return false;
		}
		
	}

?>