<?php

/*******
	created at 170922 v1.0 
	modified at 170922 v1.0.1 - edit txt pos_id, log path
	modified at 171125 v1.0.2 - fix open price
	modified at 180123 v1.0.4 - modifier add 2nd level / add max_count
	modified at 180204 v1.0.5 - add LANG INDEX control
	modified at 180206 v1.0.6 - add PLU no. to item - by Tracy
	modified at 180309 v1.0.7 - get_data_info - modifier dup record fix
	modified at 180321 v1.0.8 - fix discountable
	modified at 180628 v1.0.9 - fix tran_date (cutoff)
	modified at 180720 v1.0.10 - fix update sub-table (master_table)
	modified at 190114 v1.0.11 - fix get_data_info (modifier)
 ********/

class MobileServer extends SQL
{

	function MobileServer()
	{
		$this->SQL		= new SQL();
		$request_law	= file_get_contents('php://input');
		$request		= json_decode($request_law, true);
		// log
		$log = "\n\n" . date('r') . ' ' . $_SERVER['REMOTE_ADDR'] . "\n> " . $request_law;
		$this->sys_create_file(LOG_JSON_EXPORT . date('Ymd') . '.txt', $log, 'a');
		if (!$request['id']) return false;
		/*
			foreach ($GLOBALS['devices'] as $device) {
				$device['uuid'] = current(explode(',', $device['license']));
				if ($request['params']['uuid']==$device['uuid']) {
					$openchallenge = $device['openchallenge'];
					define('PRESET_POS_ID', $device['pos_id']);
					break;
				}
			}
			$this->table_check_no = TABLE_REFERENCE_NUMBER ? 'check_no' : 'table_no';
			*/
		// check log
		if ($request['method'] == 'send_check') {
			$sql = "SELECT * FROM [mobile_api_log] WHERE [log_id]=" . qv($request['id']);
			$record_log = $this->SQL->resultSingleArr($sql);
		}
		if ($record_log) {
			if ($record_log['request'] != $request_law) {
				$error = array('time' => $request['params']['time'], 'code' => 90002, 'message' => 'Request confused');
			} else if (time() - strtotime($record_log['date']) > 1800) {
				$error = array('time' => $request['params']['time'], 'code' => 90001, 'message' => 'Request expried');
			}
			if ($error) {
				$response = array('method' => $request['method'], 'error' => $error, 'id' => $request['id']);
				$response_law = str_replace('\/', '/', json_encode($response));
			} else {
				$response_law = $record_log['response'];
			}
		} else {
			$result = call_user_func(array($this, $request['method']), $request['params']);
			if (is_array($result)) {
				$result['time']	= $request['params']['time'];
				$response		= array('method' => $request['method'], 'result' => $result, 'id' => $request['id']);
			} else {
				$error_msgs		= array(
					10 => 'No record found',
					20001 => 'Invalid Employee',
					30001 => 'Invalid Table',
					30002 => 'Table already Released',
					30003 => 'Table already Locked',
					30004 => 'Order Settled',
					30005 => 'Order Voided',
					30006 => 'Order Closed',
					30007 => 'Order not found',
					30008 => 'Sub Table not found',
					30009 => 'Table already Opened'
				);
				$error			= array('time' => $request['params']['time'], 'code' => $result, 'message' => $error_msgs[$result]);
				$response		= array('method' => $request['method'], 'error' => $error, 'id' => $request['id']);
			}
			$response_law = str_replace('\/', '/', json_encode($response));
			// save
			$sql = "INSERT INTO [mobile_api_log] (
							[log_id],
							[date],
							[request],
							[response],
							[create_date],
							[create_by],
							[modify_date],
							[modify_by],
							[update_count]
						) VALUES (
							" . qv($request['id']) . ",
							CURRENT_TIMESTAMP,
							" . qv($request_law) . ",
							" . qv($response_law) . ",
							CURRENT_TIMESTAMP,
							" . qv($empid) . ",
							CURRENT_TIMESTAMP,
							" . qv($empid) . ",
							0
						)";
			$this->SQL->query($sql);
		}
		// log
		$log = "\n< " . $response_law;
		$this->sys_create_file(LOG_JSON_EXPORT . date('Ymd') . '.txt', $log, 'a');
		// return
		header('content-type: text/javascript');
		echo $response_law;
		return true;
	}

	function get_product_key($input)
	{
		extract($input);
		// query
		$sql = "SELECT [license_key], [expdate], [shop_id] FROM [device_map] WHERE [device_id]=" . qv($uuid);
		$record = $this->SQL->resultSingleArr($sql);
		if (!$record) return 10;
		// return
		$result = array(
			'key' => $record['license_key'],
			'expdate' => substr($record['expdate'], 0, 10),
			'outletid' => $record['shop_id']
		);
		return $result;
	}

	function get_soft_info($input)
	{
		extract($input);
		// query
		$sql = "SELECT [name" . LANG_INDEX_1 . "] AS [name1] FROM [shop] WHERE [shop_id]=" . qv($outletid);
		$record = $this->SQL->resultSingleArr($sql);
		if (!$record) return 10;
		// settings
		$settings = $GLOBALS['SOFT_INFO'][$outletid];
		foreach ($settings['languages'] as $i => $language) {
			$languages[] = array('index' => $i + 1, 'language' => $language);
		}
		$settings['outletname'] = $record['name1'];
		$settings['languages'] = $languages;
		// return
		$result = array('settings' => $settings);
		return $result;
	}

	function get_data_info($input)
	{
		extract($input);
		// query
		$sql = "SELECT [name" . LANG_INDEX_1 . "] AS [name1] FROM [shop] WHERE [shop_id]=" . qv($outletid);
		$record = $this->SQL->resultSingleArr($sql);
		if (!$record) return 1;
		// temp table
		$sql = "IF OBJECT_ID('tempdb..#lookup_header') IS NULL
					SELECT *
					INTO [#lookup_header]
					FROM [lookup_header]
					WHERE ([shop_id]=" . qv($outletid) . " OR ISNULL([shop_id], '')='')
						AND ([pos_id]=" . qv(PRESET_POS_ID) . " OR ISNULL([pos_id], '')='')
						AND ([effective_date]>=CURRENT_TIMESTAMP OR ISNULL([effective_date], '')='')
						AND ([expiry_date]<=CURRENT_TIMESTAMP OR ISNULL([expiry_date], '')='');
					
					IF OBJECT_ID('tempdb..#lookup_details') IS NULL
					SELECT D.*
					INTO [#lookup_details]
					FROM [lookup_details] D
					INNER JOIN [#lookup_header] H
						ON D.[lookup_id]=H.[lookup_id] AND D.[shop_id]=H.[shop_id] AND D.[pos_id]=H.[pos_id];
					
					IF OBJECT_ID('tempdb..#item') IS NULL
					SELECT *
					INTO [#item]
					FROM [item]
					WHERE [enable]=1;
					
					IF OBJECT_ID('tempdb..#item_price') IS NULL
					SELECT *
					INTO [#item_price]
					FROM [item_price]
					WHERE ([shop_id]=" . qv($outletid) . " OR ISNULL([shop_id], '')='') AND [price_no]=1;";
		$this->SQL->query($sql);
		// query
		switch ($data_type) {
			case 'tables':
				$sql = "SELECT T.[table_id] AS [table_no],
								T.[desc" . LANG_INDEX_1 . "] AS [name1],
								T.[desc" . LANG_INDEX_2 . "] AS [name2],
								ISNULL(S.[operation_status], 0) AS [status],
								T.[section_id]
							FROM [table] T
							LEFT JOIN [table_status] S ON S.[shop_id]=T.[shop_id] AND S.[table_id]=T.[table_id]
							WHERE T.[shop_id]=" . qv($outletid) . " AND ISNULL(T.[master_table], '')='' 
							ORDER BY T.[seqno]";
				$data = $this->SQL->resultManyArr($sql);
				break;
			case 'sections':
				$sql = "SELECT [section_id],
								[name" . LANG_INDEX_1 . "] AS [name1],
								[name" . LANG_INDEX_2 . "] AS [name2]
							FROM [section] WHERE [shop_id]=" . qv($outletid) . "
							ORDER BY [section_id]";
				$data = $this->SQL->resultManyArr($sql);
				break;
			case 'users':
				$sql = "SELECT [user_id] as [empid],
								[name" . LANG_INDEX_1 . "] AS [name1],
								[name" . LANG_INDEX_2 . "] AS [name2],
								[password] AS [emppw]
							FROM [user] WHERE [shop_id]=" . qv($outletid) . " AND [enable]=1
							ORDER BY [user_id]";
				$data = $this->SQL->resultManyArr($sql);
				break;
			case 'lookup_header':
				$sql = "SELECT D.[code] AS [lookup_id], D.[name" . LANG_INDEX_1 . "] AS [name1], D.[name" . LANG_INDEX_2 . "] AS [name2]
							FROM [#lookup_header] H
							INNER JOIN [#lookup_details] D
								ON D.[lookup_id]=H.[lookup_id] AND D.[item_type]=1
							INNER JOIN [device_map] M
								ON M.[device_id]=" . qv($uuid) . " AND M.[imenu_lookupid]=H.[lookup_id]
							WHERE H.[lookup_type]=1001
							ORDER BY D.[seq]";
				$data = $this->SQL->resultManyArr($sql);
				break;
			case 'items':
				$sql = "SELECT D.[lookup_id], D.[code] AS [item_code], I.[plu_no] AS [PLU], D.[name" . LANG_INDEX_1 . "] AS [name1], D.[name" . LANG_INDEX_2 . "] AS [name2],
								(CASE WHEN ISNULL(I.[item_set], '')='' and D.[item_type]='0' THEN 0 
								 WHEN D.[item_type]='1' THEN 1
								ELSE 2 END) AS [type],
								ISNULL(IP.[price], 0) AS [item_price],
								(CASE WHEN ISNULL(I.[open_price], 0)=0 THEN 2 ELSE 1 END) AS [open_price],
								2 AS [disable],
								(CASE WHEN ISNULL(I.[reference], 0)=0 THEN 2 ELSE 1 END) AS [open_item],
								1 AS [soldout_count],
								IP.[unit] AS [unit1], IP.[unit] AS [unit2], ISNULL(IP.[set_price], 0) AS [set_price]
							FROM [#lookup_header] H
							INNER JOIN [#lookup_details] D
								ON D.[lookup_id]=H.[lookup_id] AND D.[item_type]in('0','1')
							LEFT JOIN [#item] I
								ON I.[item_code]=D.[code] AND I.[is_modifier]=0
							LEFT JOIN [#item_price] IP
								ON IP.[item_code]=I.[item_code]
							WHERE (H.[lookup_type]=1 AND H.[lookup_id] IN (
								SELECT D.[code]
								FROM [#lookup_header] H
								INNER JOIN [#lookup_details] D
									ON D.[lookup_id]=H.[lookup_id] AND D.[item_type]=1
							)) OR (H.[lookup_type]=3 AND H.[lookup_id] IN (
								SELECT D.[code]
								FROM [#lookup_header] H
								INNER JOIN [#lookup_details] D
									ON D.[lookup_id]=H.[lookup_id] AND D.[item_type]=1
								INNER JOIN [#item] IH
									ON IH.[item_set]=H.[lookup_id] AND IH.[is_modifier]=0
								LEFT JOIN [#item] I
									ON I.[item_code]=D.[code] AND I.[is_modifier]=0
								LEFT JOIN [#item_price] IP
									ON IP.[item_code]=I.[item_code]
								WHERE H.[lookup_type]=3
							))
							ORDER BY D.[lookup_id], D.[seq]";
				$data = $this->SQL->resultManyArr($sql);
				break;
			case 'set_lookup_details':
				$sql = "SELECT IH.[item_code] AS [set_code], D.[code] AS [item_code],
								D.[item_type] AS [type],
								0 AS [allot_price], D.[name" . LANG_INDEX_1 . "] AS [name1], D.[name" . LANG_INDEX_2 . "] AS [name2],
								IP.[unit] AS [unit1], IP.[unit] AS [unit2], HH.[max_count] AS [num]
							FROM [#lookup_header] H
							INNER JOIN [#lookup_details] D
								ON D.[lookup_id]=H.[lookup_id]
							LEFT JOIN [#lookup_header] HH
								ON D.[code]=HH.[lookup_id]
							INNER JOIN [#item] IH
								ON IH.[item_set]=H.[lookup_id] AND IH.[is_modifier]=0
							LEFT JOIN [#item] I
								ON I.[item_code]=D.[code] AND I.[is_modifier]=0
							LEFT JOIN [#item_price] IP
								ON IP.[item_code]=I.[item_code]
							WHERE H.[lookup_type]=3
							ORDER BY IH.[item_code], D.[seq]";
				$data = $this->SQL->resultManyArr($sql);
				break;
			case 'modifier':
				$sql = "SELECT I.[item_code], MI.[item_code] AS [modifier_code],
								MD.[name" . LANG_INDEX_1 . "] AS [name1], MD.[name" . LANG_INDEX_2 . "] AS [name2],
								MD.[lookup_id] AS [mod_gp_id], I.[charge_type] AS [price_type],
								ISNULL(MIP.[price], 0) AS [mod_price], ISNULL(MI.[open_price], 0) AS [open_price],
								ISNULL(MH.[compulsory], 0) AS [comp], MH.[max_count]
							FROM [#lookup_header] H
							INNER JOIN [#lookup_details] D
								ON D.[lookup_id]=H.[lookup_id] AND D.[item_type]=0
							INNER JOIN [#item] I
								ON I.[item_code]=D.[code] AND I.[is_modifier]=0
							INNER JOIN [#lookup_header] MH
								ON MH.[lookup_id]=I.[modifier1] AND MH.[lookup_type]=2
							INNER JOIN [#lookup_details] MD
								ON MD.[lookup_id]=MH.[lookup_id] AND MD.[item_type]=0
							INNER JOIN [#item] MI
								ON MI.[item_code]=MD.[code]
							LEFT JOIN [#item_price] MIP
								ON MIP.[item_code]=MI.[item_code]
							WHERE ISNULL(I.[modifier1], '')!=''
							GROUP BY I.[item_code], MI.[item_code],
								MD.[name" . LANG_INDEX_1 . "], MD.[name" . LANG_INDEX_2 . "],
								MD.[lookup_id], I.[charge_type],
								MIP.[price], MI.[open_price],
								MH.[compulsory], MH.[max_count], MD.[seq]
							ORDER BY I.[item_code], MD.[seq]";
				$data1 = $this->SQL->resultManyArr($sql);
				if (!$data1) $data1 = array();
				$sql = "SELECT I.[item_code], MMI.[item_code] AS [modifier_code],
								MMD.[name" . LANG_INDEX_1 . "] AS [name1], MMD.[name" . LANG_INDEX_2 . "] AS [name2],
								MMD.[lookup_id] AS [mod_gp_id], I.[charge_type] AS [price_type],
								ISNULL(MMIP.[price], 0) AS [mod_price], ISNULL(MMI.[open_price], 0) AS [open_price],
								ISNULL(MMH.[compulsory], 0) AS [comp], MMH.[max_count]
							FROM [#lookup_header] H
							INNER JOIN [#lookup_details] D
								ON D.[lookup_id]=H.[lookup_id] AND D.[item_type]=0
							INNER JOIN [#item] I
								ON I.[item_code]=D.[code] AND I.[is_modifier]=0
							INNER JOIN [#lookup_header] MH
								ON MH.[lookup_id]=I.[modifier1] AND MH.[lookup_type]=2
							INNER JOIN [#lookup_details] MD
								ON MD.[lookup_id]=MH.[lookup_id] AND MD.[item_type]=1
							INNER JOIN [#lookup_header] MMH
								ON MMH.[lookup_id]=MD.[code] AND MMH.[lookup_type]=2
							INNER JOIN [#lookup_details] MMD
								ON MMD.[lookup_id]=MMH.[lookup_id] AND MMD.[item_type]=0
							INNER JOIN [#item] MMI
								ON MMI.[item_code]=MMD.[code]
							LEFT JOIN [#item_price] MMIP
								ON MMIP.[item_code]=MMI.[item_code]
							WHERE ISNULL(I.[modifier1], '')!=''
							GROUP BY I.[item_code], MMI.[item_code],
								MMD.[name" . LANG_INDEX_1 . "], MMD.[name" . LANG_INDEX_2 . "],
								MMD.[lookup_id], I.[charge_type],
								MMIP.[price], MMI.[open_price],
								MMH.[compulsory], MMH.[max_count], MD.[seq], MMD.[seq]
							ORDER BY I.[item_code], MD.[seq], MMD.[seq]";
				$data2 = $this->SQL->resultManyArr($sql);
				if (!$data2) $data2 = array();
				$data = array_merge($data1, $data2);
				break;
			case 'common_modifier':
				$sql = "SELECT D.[code] AS [lookup_id], D.[name" . LANG_INDEX_1 . "] AS [name1], D.[name" . LANG_INDEX_2 . "] AS [name2]
							FROM [#lookup_header] H
							INNER JOIN [#lookup_details] D
								ON D.[lookup_id]=H.[lookup_id] AND item_type=1
							WHERE H.[lookup_id]='M9999'
							ORDER BY D.[seq]";
				$data = $this->SQL->resultManyArr($sql);
				break;
			case 'modifier_lookup_details':
				$sql = "SELECT D.[code] AS [cmod_code], D.[name" . LANG_INDEX_1 . "] AS [name1], D.[name" . LANG_INDEX_2 . "] AS [name2],
								(CASE WHEN H.[lookup_id]='M9999' THEN NULL ELSE H.[lookup_id] END) AS [cmod_gp_id],
								I.[charge_type] AS [price_type], ISNULL(IP.[price], 0) AS [mod_price], ISNULL(I.[open_price], 0) AS [open_price]
							FROM [#lookup_header] H
							INNER JOIN [#lookup_details] D
								ON D.[lookup_id]=H.[lookup_id]
							INNER JOIN [#item] I
								ON I.[item_code]=D.[code] AND I.[is_modifier]=1
							LEFT JOIN [#item_price] IP
								ON IP.[item_code]=I.[item_code]
							WHERE (H.[lookup_id]='M9999' AND item_type=0)
								OR (H.[lookup_id] IN (SELECT D.[code]
									FROM [#lookup_header] H
									INNER JOIN [#lookup_details] D
										ON D.[lookup_id]=H.[lookup_id]
									WHERE H.[lookup_id]='M9999'))
							ORDER BY H.[lookup_id], D.[seq]";
				$data = $this->SQL->resultManyArr($sql);
				break;

			case 'get_soldout_count':

				/*$sql = "SELECT I.[item_code] AS [item_code],
								CONVERT(INT, S.[soldout_bal]) AS [soldout_bal]
							FROM [item] I
							INNER JOIN [item_state] S
								ON S.[item_code]=I.[item_code] 
							WHERE I.[enable]=1 AND S.[shop_id]=".qv($outletid)." 
							ORDER BY I.[item_code]";
							*/
				$sql = "SELECT I.[item_code] AS [item_code],
							(CASE WHEN ISNULL(CONVERT(INT,S.[soldout_bal]), 1)>0  THEN 1 ELSE 0 END) AS [soldout_bal]
							FROM [item] I
							LEFT JOIN (SELECT * FROM [item_state]  WHERE [shop_id]=" . qv($outletid) . " ) S
								ON S.[item_code]=I.[item_code] 
							WHERE I.[enable]=1 and I.[is_modifier]=0
							ORDER BY I.[item_code]";

				$data = $this->SQL->resultManyArr($sql);

				break;




			case 'data_last_state':
				$sql = "SELECT TOP 1 [modify_date] FROM [table] WHERE [shop_id]=" . qv($outletid) . " ORDER BY [modify_date] DESC";
				$state = $this->state($this->SQL->resultValue($sql));
				$data[] = array('data_type' => 'tables', 'state' => $state);

				$sql = "SELECT TOP 1 [modify_date] FROM [section] WHERE [shop_id]=" . qv($outletid) . " ORDER BY [modify_date] DESC";
				$state = $this->state($this->SQL->resultValue($sql));
				$data[] = array('data_type' => 'sections', 'state' => $state);

				$sql = "SELECT TOP 1 [modify_date] FROM [user] WHERE [shop_id]=" . qv($outletid) . " AND [enable]=1 ORDER BY [modify_date] DESC";
				$state = $this->state($this->SQL->resultValue($sql));
				$data[] = array('data_type' => 'users', 'state' => $state);

				$sql = "SELECT TOP 1 [modify_date] FROM [item_state] WHERE [shop_id]=" . qv($outletid) . " ORDER BY [modify_date] DESC";
				$state = $this->state($this->SQL->resultValue($sql));
				//$data[] = array('data_type'=>'get_soldout_count', 'state'=>$state);	

				$sql = "SELECT TOP 1 [modify_date] FROM (
								SELECT [modify_date] FROM [#lookup_header]
								UNION ALL
								SELECT [modify_date] FROM [#lookup_details]
								UNION ALL
								SELECT [modify_date] FROM [#item]
							) AS T ORDER BY [modify_date] DESC";
				$state = $this->state($this->SQL->resultValue($sql));
				$data[] = array('data_type' => 'lookup_header', 'state' => $state);
				$data[] = array('data_type' => 'items', 'state' => $state);
				$data[] = array('data_type' => 'modifier', 'state' => $state);
				$data[] = array('data_type' => 'set_lookup_details', 'state' => $state);
				$data[] = array('data_type' => 'common_modifier', 'state' => $state);
				$data[] = array('data_type' => 'modifier_lookup_details', 'state' => $state);
				$data[] = array('data_type' => 'get_soldout_count', 'state' => $state);
				$data[] = array('data_type' => 'data_last_state', 'state' => $state);
				break;
		}
		// return
		$result = array(
			'businessdate' => date('Y-m-d'),
			'data' => $data
		);
		return $result;
	}

	function table_status($input)
	{
		extract($input);
		// query
		$sql = "SELECT [table_id] FROM [table] WHERE [shop_id]=" . qv($outletid) . " AND ISNULL([master_table], '')='' ORDER BY [seqno]";
		$records = $this->SQL->resultSingleFieldArr($sql);
		if (!$records) return 10;
		// lock tables
		/*
			if (is_array($locked_tables) && count($locked_tables)) {
				if (count($locked_tables)!=count(array_intersect($locked_tables, $records))) return 30001;
				foreach ($locked_tables as $locked_table) {
					$sql = "SELECT COUNT(*) FROM [table_status] WHERE [shop_id]=".qv($outletid)." AND [table_id]=".qv($locked_table);
					$exist = $this->SQL->resultValue($sql);
					if ($exist) {
						$sql = "UPDATE [table_status] SET 
									[operation_status]=[operation_status]+128,
									[status_time]=CURRENT_TIMESTAMP,
									[modify_date]=CURRENT_TIMESTAMP,
									[modify_by]=".qv($empid).",
									[update_count]=[update_count]+1
								WHERE [shop_id]=".qv($outletid)." AND [table_id]=".qv($locked_table)." AND [operation_status]<128";
					} else {
						$sql = "INSERT INTO [table_status] (
									[table_id],
									[seat_seq],
									[operation_status],
									[status_time],
									[create_date],
									[create_by],
									[modify_date],
									[modify_by],
									[update_count],
									[shop_id],
									[pos_id]
								) VALUES (
									".qv($locked_table).",
									0,
									128,
									CURRENT_TIMESTAMP,
									CURRENT_TIMESTAMP,
									".qv($empid).",
									CURRENT_TIMESTAMP,
									".qv($empid).",
									0,
									".qv($outletid).",
									".qv(PRESET_POS_ID)."
								)";
					}
					$this->SQL->query($sql);
				}
			}
			*/
		// status
		$sql = "SELECT [table_id], [operation_status] FROM [table_status] WHERE [shop_id]=" . qv($outletid);
		$tmp_records = $this->SQL->resultManyArr($sql);
		if (is_array($tmp_records)) foreach ($tmp_records as $tmp_record) $status[$tmp_record['table_id']] = $tmp_record['operation_status'];
		// tables
		foreach ($records as $table_no) {
			$tables[] = array(
				'table_no' => $table_no,
				'status' => i($status[$table_no])
			);
		}
		// return
		$result = array(
			'businessdate' => date('Y-m-d'),
			'tables' => $tables
		);
		return $result;
	}

	function login($input)
	{
		extract($input);
		// query
		list($record_right, $record) = $this->sys_check_user($outletid, $empid, $emppw, '00001');
		if (
			!$record_right ||
			($record['effective_date'] && strtotime($record['effective_date']) > time()) ||
			($record['expiry_date'] && strtotime($record['expiry_date']) < time())
		)	return 20001;
		// return
		$result = array(
			'empid' => $empid,
			'businessdate' => date('Y-m-d')
		);
		return $result;
	}

	function get_table($input)
	{
		extract($input);
		// query
		$sql = "SELECT [table_id] FROM [table] WHERE [shop_id]=" . qv($outletid) . " AND [table_id]=" . qv($table_no);
		$record = $this->SQL->resultValue($sql);
		if (!$record) return 30001;
		// sub_table
		$sql = "SELECT COUNT(*)
					FROM [table] T
					LEFT JOIN [table_status] S ON S.[shop_id]=T.[shop_id] AND S.[table_id]=T.[table_id]
					WHERE T.[shop_id]=" . qv($outletid) . " AND T.[master_table]=" . qv($table_no) . "
						AND ISNULL(S.[operation_status], 0)>0";
		$total_subtable = $this->SQL->resultValue($sql);
		if ($sub_table && $total_subtable) {
			// sub tables
			$sql = "SELECT T.[table_id] AS [table_no], ISNULL(S.[operation_status], 0) AS [table_status],
							S.[cover], S.[total_amount] AS [amount]
						FROM [table] T
						LEFT JOIN [table_status] S ON S.[shop_id]=T.[shop_id] AND S.[table_id]=T.[table_id]
						WHERE T.[shop_id]=" . qv($outletid) . " AND (T.[table_id]=" . qv($table_no) . " OR T.[master_table]=" . qv($table_no) . ")
							AND ISNULL(S.[operation_status], 0)>0
						ORDER BY T.[seqno]";
			$record_tables = $this->SQL->resultManyArr($sql);
			// result
			$result = array(
				'sub_table' => 1,
				'tables' => $record_tables
			);
		} else {
			// check_details
			$sql = "SELECT [table_id], [operation_status], [cover], [total_amount], [tran_no] FROM [table_status]
						WHERE [shop_id]=" . qv($outletid) . " AND [table_id]=" . qv($table_no);
			$record_status = $this->SQL->resultSingleArr($sql);
			$check_details[] = array(
				'table_no' => $table_no,
				'name1' => NULL,
				'name2' => NULL,
				'cover' => i($record_status['cover']),
				'amount' => n($record_status['amount'])
			);
			// items
			$sql = "SELECT D.*
						FROM [sales_details] D
						INNER JOIN [sales_header] H
							ON H.[shop_id]=D.[shop_id] AND H.[tran_no]=D.[tran_no]
						WHERE H.[tran_no]=" . qv($record_status['tran_no']) . " AND H.[shop_id]=" . qv($outletid) . "
							AND H.[settled]='0' AND H.[void_status]=0 AND H.[close_id]=''";
			$record_details = $this->SQL->resultManyArr($sql);
			$seq_no = 0;
			if (is_array($record_details)) foreach ($record_details as $record_detail) {
				if ($record_detail['subtype'] == 2) {
					$i = $record_detail['link_row'];
					$items[$i]['mod_code'] = $record_detail['code'];
					$items[$i]['mod_name1'] = $record_detail['desc' . LANG_INDEX_1];
					$items[$i]['mod_name2'] = $record_detail['desc' . LANG_INDEX_2];
				} else {
					$seq_no++;
					$i = $record_detail['seqno'];
					$items[$i] = array(
						'seq_no' => $seq_no,
						'item_code' => $record_detail['code'],
						'name1' => $record_detail['desc' . LANG_INDEX_1],
						'name2' => $record_detail['desc' . LANG_INDEX_2],
						'mod_code' => NULL,
						'mod_name1' => NULL,
						'mod_name2' => NULL,
						'qty' => i($record_detail['qty']),
						'unit1' => $record_detail['unit'],
						'unit2' => $record_detail['unit'],
						'price' => n($record_detail['price'])
					);
				}
			}
			sort($items);
			// result
			$result = array(
				'sub_table' => 0,
				'table_status' => i($record_status['operation_status']),
				'check_details' => $check_details,
				'items' => $items
			);
		}
		// return
		return $result;
	}

	function release_table($input)
	{
		extract($input);
		// query
		$sql = "SELECT [operation_status] FROM [table_status] WHERE [shop_id]=" . qv($outletid) . " AND [table_id]=" . qv($table_no);
		$record = $this->SQL->resultSingleArr($sql);
		if (!$record) return 30001;
		if ($record['operation_status'] < 128) return 30002;
		// release tables
		$sql = "UPDATE [table_status] SET 
						[operation_status]=[operation_status]-128,
						[status_time]=CURRENT_TIMESTAMP,
						[modify_date]=CURRENT_TIMESTAMP,
						[modify_by]=" . qv($empid) . ",
						[update_count]=[update_count]+1
					WHERE [shop_id]=" . qv($outletid) . " AND [table_id]=" . qv($table_no) . " AND [operation_status]>=128";
		$this->SQL->query($sql);
		// return
		$result = array('status' => 'OK');
		return $result;
	}

	function open_table($input)
	{
		extract($input);
		// query
		$sql = "SELECT COUNT(*) FROM [table] WHERE [shop_id]=" . qv($outletid) . " AND [table_id]=" . qv($table_no);
		$exist = $this->SQL->resultValue($sql);
		if (!$exist) return 30001;
		// query
		$sql = "SELECT [operation_status] FROM [table_status] WHERE [shop_id]=" . qv($outletid) . " AND [table_id]=" . qv($table_no);
		$record = $this->SQL->resultSingleArr($sql);
		if ($record['operation_status'] >= 128) return 30003;
		// lock tables
		$sql = "SELECT COUNT(*) FROM [table_status] WHERE [shop_id]=" . qv($outletid) . " AND [table_id]=" . qv($table_no);
		$exist = $this->SQL->resultValue($sql);
		if ($exist) {
			$sql = "UPDATE [table_status] SET 
							[operation_status]=[operation_status]+128,
							[status_time]=CURRENT_TIMESTAMP,
							[modify_date]=CURRENT_TIMESTAMP,
							[modify_by]=" . qv($empid) . ",
							[update_count]=[update_count]+1
						WHERE [shop_id]=" . qv($outletid) . " AND [table_id]=" . qv($table_no) . " AND [operation_status]<128";
		} else {
			$sql = "SELECT master_table FROM [table] WHERE [shop_id]=" . qv($outletid) . " AND [table_id]=" . qv($table_no);
			$master_table = $this->SQL->resultValue($sql);
			$sql = "INSERT INTO [table_status] (
							[table_id],
							[table_code],
							[seat_seq],
							[operation_status],
							[status_time],
							[create_date],
							[create_by],
							[modify_date],
							[modify_by],
							[update_count],
							[shop_id],
							[pos_id]
						) VALUES (
							" . qv($table_no) . ",
							" . qv($master_table ? $master_table : $table_no) . ",
							0,
							128,
							CURRENT_TIMESTAMP,
							CURRENT_TIMESTAMP,
							" . qv($empid) . ",
							CURRENT_TIMESTAMP,
							" . qv($empid) . ",
							0,
							" . qv($outletid) . ",
							" . qv(PRESET_POS_ID) . "
						)";
		}
		$this->SQL->query($sql);
		// return
		$result = array('status' => 'OK');
		return $result;
	}

	function get_sub_table($input)
	{
		extract($input);
		// query
		$sql = "SELECT COUNT(*) FROM [table] WHERE [shop_id]=" . qv($outletid) . " AND [table_id]=" . qv($table_no);
		$record = $this->SQL->resultValue($sql);
		if (!$record) return 30001;
		// sub tables
		$sql = "SELECT TOP 1 T.[table_id]
					FROM [table] T
					LEFT JOIN [table_status] S ON S.[shop_id]=T.[shop_id] AND S.[table_id]=T.[table_id]
					WHERE T.[shop_id]=" . qv($outletid) . " AND T.[master_table]=" . qv($table_no) . "
						AND ISNULL(S.[operation_status], 0)=0
					ORDER BY T.[seqno], T.[table_id]";
		$sub_table = $this->SQL->resultValue($sql);
		if (!$sub_table) return 30008;
		// open_table
		$data = array('empid' => $empid, 'outletid' => $outletid, 'table_no' => $sub_table);
		$result = $this->open_table($data);
		if ($result['status'] != 'OK') return 30008;
		// return
		$result = array('sub_table' => $sub_table);
		return $result;
	}

	function change_cover($input)
	{
		extract($input);
		// table_status
		$sql = "SELECT T.[table_id], TS.[operation_status], TS.[tran_no]
					FROM [table] T
					LEFT JOIN [table_status] TS ON TS.[shop_id]=T.[shop_id] AND TS.[table_id]=T.[table_id]
					WHERE T.[shop_id]=" . qv($outletid) . " AND T.[table_id]=" . qv($tableid);
		$record = $this->SQL->resultSingleArr($sql);
		if (!$record) return 30001;
		//if ($record['operation_status']>=128) return 30003;
		// sales_header
		$sql = "SELECT * FROM [sales_header] WHERE [shop_id]=" . qv($outletid) . " AND [tran_no]=" . qv($record['tran_no']);
		$record_tran = $this->SQL->resultSingleArr($sql);
		if (!$record_tran) return 30007;
		if ($record_tran['settled']) return 30004;
		if ($record_tran['void_status']) return 30005;
		if ($record_tran['close_id']) return 30006;
		// update
		$sql = "UPDATE [table_status] SET 
						[cover]=" . i($newcover) . ",
						[modify_date]=CURRENT_TIMESTAMP,
						[modify_by]=" . qv($empid) . ",
						[update_count]=[update_count]+1
					WHERE [shop_id]=" . qv($outletid) . " AND [table_id]=" . qv($tableid) . ";
					
					UPDATE [sales_header] SET 
						[cover]=" . i($newcover) . ",
						[modify_date]=CURRENT_TIMESTAMP,
						[modify_by]=" . qv($empid) . ",
						[update_count]=[update_count]+1
					WHERE [shop_id]=" . qv($outletid) . " AND [tran_no]=" . qv($record['tran_no']) . ";";
		$this->SQL->query($sql);
		// return
		$result = array('status' => 'OK');
		return $result;
	}

	function change_table($input)
	{
		extract($input);
		// table_status
		$sql = "SELECT T.[table_id], T.[master_table], TS.[operation_status], TS.[tran_no]
					FROM [table] T
					LEFT JOIN [table_status] TS ON TS.[shop_id]=T.[shop_id] AND TS.[table_id]=T.[table_id]
					WHERE T.[shop_id]=" . qv($outletid) . " AND T.[table_id]=" . qv($tableid);
		$record = $this->SQL->resultSingleArr($sql);
		if (!$record) return 30001;
		#if ($record['operation_status']>=128) return 30003;
		// sales_header
		$sql = "SELECT * FROM [sales_header] WHERE [shop_id]=" . qv($outletid) . " AND [tran_no]=" . qv($record['tran_no']);
		$record_tran = $this->SQL->resultSingleArr($sql);
		if (!$record_tran) return 30007;
		if ($record_tran['settled']) return 30004;
		if ($record_tran['void_status']) return 30005;
		if ($record_tran['close_id']) return 30006;
		// table_status new
		$sql = "SELECT T.[table_id], T.[master_table], TS.[operation_status], TS.[tran_no]
					FROM [table] T
					LEFT JOIN [table_status] TS ON TS.[shop_id]=T.[shop_id] AND TS.[table_id]=T.[table_id]
					WHERE T.[shop_id]=" . qv($outletid) . " AND T.[table_id]=" . qv($new_tableid);
		$record_new = $this->SQL->resultSingleArr($sql);
		if (!$record_new) return 30001;
		if ($record_new['operation_status'] >= 128) return 30003;
		$sql = "SELECT COUNT(*) FROM [table_status] WHERE [shop_id]=" . qv($outletid) . " AND [table_id]=" . qv($new_tableid);
		$exist = $this->SQL->resultValue($sql);
		if (!$exist) {
			$sql = "SELECT master_table FROM [table] WHERE [shop_id]=" . qv($outletid) . " AND [table_id]=" . qv($new_tableid);
			$master_table = $this->SQL->resultValue($sql);
			$sql = "INSERT INTO [table_status] (
									[table_id],
									[table_code],
									[seat_seq],
									[operation_status],
									[status_time],
									[create_date],
									[create_by],
									[modify_date],
									[modify_by],
									[update_count],
									[shop_id],
									[pos_id]
								) VALUES (
									" . qv($new_tableid) . ",
									" . qv($master_table ? $master_table : $new_tableid) . ",
									0,
									0,
									CURRENT_TIMESTAMP,
									CURRENT_TIMESTAMP,
									" . qv($empid) . ",
									CURRENT_TIMESTAMP,
									" . qv($empid) . ",
									0,
									" . qv($outletid) . ",
									" . qv(PRESET_POS_ID) . "
								)";
			$this->SQL->query($sql);
		}
		// sales_header new
		if ($record_new['tran_no']) {
			$sql = "SELECT [settled] FROM [sales_header] WHERE [shop_id]=" . qv($outletid) . " AND [tran_no]=" . qv($record_new['tran_no']);
			$record_tran_new = $this->SQL->resultSingleArr($sql);
			if (!$record_tran_new['settled']) return 30009;
		}
		// update
		$tmp_tableid	= 'TMP' . date('His');
		$new_tablecode	= $record_new['master_table'] ? $record_new['master_table'] : $record_new['table_id'];
		$sql = "UPDATE [table_status] SET 
						[table_id]=" . qv($tmp_tableid) . "
					WHERE [shop_id]=" . qv($outletid) . " AND [table_id]=" . qv($new_tableid) . ";
					
					UPDATE [table_status] SET 
						[table_id]=" . qv($new_tableid) . ",
						[operation_status]=[operation_status]-128,
						[modify_date]=CURRENT_TIMESTAMP,
						[modify_by]=" . qv($empid) . ",
						[update_count]=[update_count]+1
					WHERE [shop_id]=" . qv($outletid) . " AND [table_id]=" . qv($tableid) . ";
					
					UPDATE [table_status] SET 
						[table_id]=" . qv($tableid) . ",
						[modify_date]=CURRENT_TIMESTAMP,
						[modify_by]=" . qv($empid) . ",
						[update_count]=[update_count]+1
					WHERE [shop_id]=" . qv($outletid) . " AND [table_id]=" . qv($tmp_tableid) . ";
					
					UPDATE [sales_header] SET 
						[table_no]=" . qv($new_tableid) . ",
						[table_code]=" . qv($new_tablecode) . ",
						[modify_date]=CURRENT_TIMESTAMP,
						[modify_by]=" . qv($empid) . ",
						[update_count]=[update_count]+1
					WHERE [shop_id]=" . qv($outletid) . " AND [tran_no]=" . qv($record['tran_no']) . ";";
		$this->SQL->query($sql);
		// return
		$result = array('status' => 'OK');
		return $result;
	}

	function check_update($input)
	{
		extract($input);
		// query
		$last_states = $this->get_data_info(array('outletid' => $outletid, 'data_type' => 'data_last_state'));
		if (is_array($last_states['data'])) foreach ($last_states['data'] as $last_state) {
			$data_type	= $last_state['data_type'];
			$state1		= $last_state['state'];
			$state2		= $$data_type;
			if ($state1 != $state2) {
				$records = $this->get_data_info(array('outletid' => $outletid, 'data_type' => $data_type, 'uuid' => $uuid));
				$data[] = array(
					'data_type'	=> $data_type,
					'state'		=> $state1,
					'records'	=> $records['data']
				);
			}
		}
		if (!count($data)) $data = 'ALLOK';
		// return
		$result = array(
			'businessdate' => date('Y-m-d'),
			'data' => $data
		);
		return $result;
	}

	/*		function get_soldout_count($input) {
			extract($input);
			// query
			$sql = "SELECT I.[item_code], S.[soldout_bal]
					FROM [item] I
					INNER JOIN [item_state] S
						ON S.[item_code]=I.[item_code] AND S.[shop_id]=".qv($outletid)."
					WHERE I.[enable]=1";
			$records = $this->SQL->resultManyArr($sql);
			// return
			$result = array('businessdate'=>date('Y-m-d'),
							'items'=>$records);
			return $result;
		}
*/
	function send_check($input)
	{
		extract($input);
		// content
		$sql = "SELECT * FROM [table] WHERE [shop_id]=" . qv($outletid) . " AND [table_id]=" . qv($tableid);
		$record_table = $this->SQL->resultSingleArr($sql);
		if (!$record_table) return 30001;
		$sql = "SELECT * FROM [section] WHERE [section_id]=" . qv($record_table['section_id']);
		$record_section = $this->SQL->resultSingleArr($sql);
		$sql = "SELECT * FROM [charges] WHERE [id]=" . qv($record_section['chg_id']);
		$record_charges = $this->SQL->resultSingleArr($sql);
		$sql = "SELECT * FROM [tax] WHERE [tax_id]=" . qv($record_section['tax_id']);
		$record_tax = $this->SQL->resultSingleArr($sql);
		$sql = "SELECT * FROM [sales_header] WHERE [table_no]=" . qv($tableid) . " AND [settled]='0' AND [void_status]=0 AND [close_id]=''";
		$record_sales_header = $this->SQL->resultSingleArr($sql);
		// pos_id
		$sql = "SELECT [pos_id] FROM [device_map] WHERE [device_id]=" . qv($uuid);
		$pos_id = $this->SQL->resultValue($sql);
		if ($record_sales_header['check_no']) {
			$tran_date	= $record_sales_header['tran_date'];
			$tran_no	= $record_sales_header['tran_no'];
			$check_no	= $record_sales_header['check_no'];
			$sql = "SELECT TOP 1 [seqno] FROM [sales_details]
						WHERE [shop_id]=" . qv($record_sales_header['shop_id']) . " AND [tran_no]=" . qv($record_sales_header['tran_no']) . "
						ORDER BY seqno DESC";
			$seqno = $this->SQL->resultValue($sql);
			// insert
			if (is_array($items)) foreach ($items as $item) {
				switch ($item['type']) {
					case 2:
						$subtype = 2;
						$level_no = $items[$item['seq_no'] - 1]['type'] == 4 ? 2 : 1;
						break;
					case 4:
						$subtype = 4;
						$level_no = 1;
						break;
					default:
						$subtype = 0;
						$level_no = 0;
						break;
				}
				$data = array(
					'tran_date' => $tran_date,
					'tran_no' => $tran_no,
					'seqno' => $item['seq_no'] + $seqno,
					'subtype' => $subtype,
					'link_row' => $item['link_row'] ? $item['link_row'] + $seqno : 0,
					'check_no' => $check_no,
					'level_no' => $level_no,
					'code' => $item['plu'],
					'qty' => i($item['qty']),
					'empid' => $empid,
					'tableid' => $tableid,
					'opendesc' => $item['open_desc'],
					'open_price' => n($item['open_price'])
				);
				list($record_item, $subtotal_amount, $chargeable, $taxable) = $this->sys_insert_sales_details($data, $subtotal_amount, $chargeable, $taxable, $outletid, $record_sales_header['pos_id']);
			}
			$svchg_amount	= ($record_charges['value'] * $chargeable) / 100;
			$tax_amount		= ($record_tax['value'] * $taxable) / 100;
			$sql = "UPDATE [sales_header] SET
							[cover]=" . qv($cover) . ",
							[chg_id]=" . qv($record_charges['id']) . ",
							[svchg_rate]=" . qv($record_charges['value']) . ",
							[svchg_amount]=[svchg_amount]+" . $svchg_amount . ",
							[svchg_desc1]=" . qv($record_charges['desc' . LANG_INDEX_1]) . ",
							[svchg_desc2]=" . qv($record_charges['desc' . LANG_INDEX_2]) . ",
							[svchg_by]=" . qv($empid) . ",
							[tax_id]=" . qv($record_tax['id']) . ",
							[tax_rate]=" . i($record_tax['value']) . ",
							[tax_amount]=[tax_amount]+" . $tax_amount . ",
							[subtotal_amount]=[subtotal_amount]+" . $subtotal_amount . ",
							[total_amount]=[total_amount]+" . ($subtotal_amount + $svchg_amount + $tax_amount) . ",
							[balance_amount]=[balance_amount]+" . ($subtotal_amount + $svchg_amount + $tax_amount) . ",
							[capture_systime]=CURRENT_TIMESTAMP,
							[capture_reproc_req]=1
						WHERE [table_no]=" . qv($tableid) . " AND [settled]='0' AND [void_status]=0 AND [close_id]=''";
			$this->SQL->query($sql);
		} else {
			// tran_date
			$sql = "SELECT key_value FROM [appsettings] WHERE [setting_id]='0' AND [app_id]='0010001' AND [set_key]='CUTOFF'";
			$cutoff = $this->SQL->resultValue($sql);
			$tran_date = i(date('Hi')) < i(str_replace(':', '', $cutoff)) ? date('Y-m-d', strtotime('-1 day')) : date('Y-m-d');
			// tran_no
			$sql = "BEGIN TRAN
							SELECT TOP (1) * FROM [tranno] WITH (HOLDLOCK, TABLOCKX)
								WHERE [shop_id]=" . qv($outletid) . " AND ([pos_id]=" . qv(PRESET_POS_ID) . " OR [pos_id]='') AND [id]='SALESTRANNO' ORDER BY [pos_id] DESC
							UPDATE TOP (1) [tranno] SET [seq]=[seq]+1
								WHERE [shop_id]=" . qv($outletid) . " AND ([pos_id]=" . qv(PRESET_POS_ID) . " OR [pos_id]='') AND [id]='SALESTRANNO'
						COMMIT TRAN
						ROLLBACK TRAN";
			$record_tranno_salestranno = $this->SQL->resultSingleArr($sql);
			$length = $record_tranno_salestranno['length'] - strlen($record_tranno_salestranno['prefix']) + strlen($record_tranno_salestranno['suffix']);
			$tran_no = $record_tranno_salestranno['prefix'] . sprintf("%0{$length}d", $record_tranno_salestranno['seq'] + 1) . $record_tranno_salestranno['suffix'];
			// check_no
			if (TABLE_REFERENCE_NUMBER) {
				$check_no = $tablerefno;
			} else {
				$sql = "BEGIN TRAN
								SELECT TOP (1) * FROM [tranno] WITH (HOLDLOCK, TABLOCKX)
									WHERE [shop_id]=" . qv($outletid) . " AND ([pos_id]=" . qv(PRESET_POS_ID) . " OR [pos_id]='') AND [id]='CHECKNO' ORDER BY [pos_id] DESC
								UPDATE TOP (1) [tranno] SET [seq]=[seq]+1
									WHERE [shop_id]=" . qv($outletid) . " AND ([pos_id]=" . qv(PRESET_POS_ID) . " OR [pos_id]='') AND [id]='CHECKNO'
							COMMIT TRAN
							ROLLBACK TRAN";
				$record_tranno_checkno = $this->SQL->resultSingleArr($sql);
				$length = $record_tranno_checkno['length'] - strlen($record_tranno_checkno['prefix']) + strlen($record_tranno_checkno['suffix']);
				$check_no = $record_tranno_checkno['prefix'] . sprintf("%0{$length}d", $record_tranno_checkno['seq'] + 1) . $record_tranno_checkno['suffix'];
			}
			// slip_no
			$sql = "BEGIN TRAN
							SELECT TOP (1) * FROM [tranno] WITH (HOLDLOCK, TABLOCKX)
								WHERE [shop_id]=" . qv($outletid) . " AND ([pos_id]=" . qv(PRESET_POS_ID) . " OR [pos_id]='') AND [id]='SLIPNO' ORDER BY [pos_id] DESC
							UPDATE TOP (1) [tranno] SET [seq]=[seq]+1
								WHERE [shop_id]=" . qv($outletid) . " AND ([pos_id]=" . qv(PRESET_POS_ID) . " OR [pos_id]='') AND [id]='SLIPNO'
						COMMIT TRAN
						ROLLBACK TRAN";
			$record_tranno_slipno = $this->SQL->resultSingleArr($sql);
			$length = $record_tranno_slipno['length'] - strlen($record_tranno_slipno['prefix']) + strlen($record_tranno_slipno['suffix']);
			$slip_no = $record_tranno_slipno['prefix'] . sprintf("%0{$length}d", $record_tranno_slipno['seq'] + 1) . $record_tranno_slipno['suffix'];
			// seqno
			$seqno = 0;
			// insert
			if (is_array($items)) foreach ($items as $item) {
				switch ($item['type']) {
					case 2:
						$subtype = 2;
						$level_no = $items[$item['seq_no'] - 1]['type'] == 4 ? 2 : 1;
						break;
					case 4:
						$subtype = 4;
						$level_no = 1;
						break;
					default:
						$subtype = 0;
						$level_no = 0;
						break;
				}
				$data = array(
					'tran_date' => $tran_date,
					'tran_no' => $tran_no,
					'seqno' => $item['seq_no'] + $seqno,
					'subtype' => $subtype,
					'link_row' => $item['link_row'] ? $item['link_row'] + $seqno : 0,
					'check_no' => $check_no,
					'level_no' => $level_no,
					'code' => $item['plu'],
					'qty' => $item['qty'],
					'empid' => $empid,
					'tableid' => $tableid,
					'opendesc' => $item['open_desc'],
					'open_price' => i($item['open_price'])
				);
				list($record_item, $subtotal_amount, $chargeable, $taxable) = $this->sys_insert_sales_details($data, $subtotal_amount, $chargeable, $taxable, $outletid, $pos_id);
			}
			$svchg_amount	= ($record_charges['value'] * $chargeable) / 100;
			$tax_amount		= ($record_tax['value'] * $taxable) / 100;
			$sql = "INSERT INTO [sales_header] (
							[shop_id], 
							[pos_id], 
							[tran_type], 
							[tran_date], 
							[check_date], 
							[tran_no], 
							[check_no], 
							[slip_no], 
							[table_no], 
							[close_id], 
							[section_id], 
							[cover], 
							[subtype], 
							[table_type], 
							[cur_code], 
							[cur_rate1], 
							[cur_rate2], 
							[chg_id], 
							[svchg_rate], 
							[svchg_amount], 
							[svchg_desc1], 
							[svchg_desc2], 
							[svchg_by], 
							[tax_id], 
							[tax_rate], 
							[tax_amount], 
							[subtotal_amount], 
							[total_amount], 
							[balance_amount], 
							[table_code], 
							[capture_systype], 
							[capture_systime], 
							[capture_reproc_req],
							[capture_reproc_status]
						) VALUES (
							" . qv($outletid) . ",
							" . qv($pos_id) . ",
							0,
							" . qv($tran_date) . ",
							" . qv(date('Y-m-d H:i:s')) . ",
							" . qv($tran_no) . ",
							" . qv($check_no) . ",
							" . qv($slip_no) . ",
							" . qv($record_table['table_id']) . ",
							'',
							" . qv($record_table['section_id']) . ",
							" . i($cover) . ",
							" . qv($record_section['section_type']) . ",
							" . qv($record_section['section_type']) . ",
							'HKD',
							1,
							1,
							" . qv($record_charges['id']) . ",
							" . i($record_charges['value']) . ",
							" . $svchg_amount . ",
							" . qv($record_charges['desc1']) . ",
							" . qv($record_charges['desc2']) . ",
							" . qv($empid) . ",
							" . qv($record_tax['id']) . ",
							" . i($record_tax['value']) . ",
							" . $tax_amount . ",
							" . $subtotal_amount . ",
							" . ($subtotal_amount + $svchg_amount + $tax_amount) . ",
							" . ($subtotal_amount + $svchg_amount + $tax_amount) . ",
							" . qv($record_table['master_table'] ? $record_table['master_table'] : $record_table['table_id']) . ",
							1,
							CURRENT_TIMESTAMP,
							1,
							0
						)";
			$this->SQL->query($sql);
		}
		// print
		$record = '01,' . $outletid . ',' . $pos_id . ',' . $tableid . ',' . $tran_no . ',' . $check_no . ',' . date('Y-m-d') . ',' . date('Y-m-d H:i:s') . ',' . $empid;
		$this->sys_create_printer_txt($record);
		// return
		$result = array(
			'businessdate' => date('Y-m-d'),
			'check_no' => $check_no
		);
		return $result;
	}

	function review_check($input)
	{
		extract($input);
		// content
		$sql = "SELECT * FROM [table] WHERE [shop_id]=" . qv($outletid) . " AND [table_id]=" . qv($tableid);
		$record_table = $this->SQL->resultSingleArr($sql);
		if (!$record_table) return 30001;
		$sql = "SELECT [total_amount], [svchg_amount], [disc_amount], [subtotal_amount] AS [net_amount]
					FROM [sales_header] WHERE [table_no]=" . qv($tableid) . " AND [settled]='0' AND [void_status]=0 AND [close_id]=''";
		$record_sales_header = $this->SQL->resultSingleArr($sql);
		// return
		$result = array(
			'businessdate' => date('Y-m-d'),
			'details' => $record_sales_header
		);
		return $result;
	}

	function print_detail_check($input)
	{
		extract($input);
		// pos_id
		$sql = "SELECT [pos_id] FROM [device_map] WHERE [device_id]=" . qv($uuid);
		$pos_id = $this->SQL->resultValue($sql);
		// print
		$record = '02,' . $outletid . ',' . $pos_id . ',' . $tableid . ',' . $empid;
		$this->sys_create_printer_txt($record);
		// return
		$result = array(
			'businessdate' => date('Y-m-d'),
			'status' => 'OK'
		);
		return $result;
	}

	function get_member($input)
	{
		extract($input);
		// content
		$sql = "SELECT [name" . LANG_INDEX_1 . "] AS [name] FROM [customer] WHERE [cust_code]=" . qv($memberid);
		$record = $this->SQL->resultSingleArr($sql);
		if (!$record) return 10;
		// return
		$result = array(
			'businessdate' => date('Y-m-d'),
			'membername' => $record['name']
		);
		return $result;
	}



	// common function

	function q($s = '')
	{
		return str_replace("'", "''", $s);
	}

	function state($datetime)
	{
		return date('YmdHis', strtotime($datetime));
	}

	function sys_insert_sales_details($data, $subtotal_amount, $chargeable, $taxable, $shop_id, $pos_id)
	{
		$sql = "SELECT item.*, item_price.price, item_price.unit FROM [item], [item_price]
					WHERE [item].[item_code]=" . qv($data['code']) . " AND [item].[item_code]=[item_price].[item_code]
						AND [item_price].[shop_id]=" . qv($shop_id) . " AND [item_price].[price_no]='1'";
		$record_item = $this->SQL->resultSingleArr($sql);
		$sql = "SELECT [disc_type] FROM [discount] WHERE [id]=" . qv($record_item['discid']);
		$disc_type = $this->SQL->resultValue($sql);
		$sql = "SELECT [value] FROM [discount] WHERE [id]=" . qv($record_item['discid']) . " AND [disc_type]='0'";
		$disc_rate = $this->SQL->resultValue($sql);
		$price = $record_item['open_price'] ? $data['open_price'] : $record_item['price'];
		$disc_amount = $disc_type ? $disc_rate : $data['qty'] * $price * $disc_rate;
		$amount				= $data['qty'] * $price;
		$total_amount		= $amount - $disc_amount;
		$subtotal_amount	+= $total_amount;
		if ($record_item['chargeable'] == 1) $chargeable += $amount;
		if ($record_item['taxable'] == 1) $taxable += $amount;
		if ($data['subtype'] == 2) {
			$sql = "SELECT * FROM [sales_details]
						WHERE [shop_id]=" . qv($shop_id) . " AND [tran_no]=" . qv($data['tran_no']) . " AND [seqno]=" . qv($data['link_row']);
			$record_parent = $this->SQL->resultSingleArr($sql);
			if (!$record_item['dept_id'])	$record_item['dept_id']	= $record_parent['dept_id'];
			if (!$record_item['cat_id'])	$record_item['cat_id']	= $record_parent['cat_id'];
			if (!$record_item['class_id'])	$record_item['class_id'] = $record_parent['class_id'];
		}
		// insert
		$sql = "INSERT INTO [sales_details] (
						[shop_id], 
						[pos_id], 
						[tran_type], 
						[tran_no], 
						[tran_date], 
						[det_type], 
						[seqno], 
						[subtype], 
						[link_row], 
						[shift_no], 
						[close_id], 
						[start_id], 
						[check_no], 
						[order_date], 
						[void_status], 
						[level_no], 
						[code], 
						[dept_id], 
						[cat_id], 
						[class_id], 
						[desc1], 
						[desc2], 
						[qty], 
						[rate], 
						[unit], 
						[price_level], 
						[price], 
						[amount], 
						[discountable], 
						[disc_id], 
						[disc_type], 
						[disc_rate], 
						[disc_amount], 
						[disc_by], 
						[disc_ref], 
						[disc_desc1], 
						[disc_desc2], 
						[total_amount], 
						[cdisc_amount], 
						[svchargeable], 
						[svchg_rate], 
						[svchg_amount], 
						[taxable], 
						[tax_id], 
						[tax_rate], 
						[tax_amount], 
						[net_amount], 
						[order_by], 
						[order_shop], 
						[order_pos], 
						[salesman_id], 
						[is_modifier], 
						[barcode], 
						[stock_code], 
						[cost], 
						[total_cost], 
						[print_count], 
						[ticket_print], 
						[ticket_printed], 
						[ticketprn_updcount], 
						[ticket_no], 
						[reference], 
						[buy_qty], 
						[free_qty], 
						[create_date], 
						[create_by], 
						[modify_date], 
						[modify_by], 
						[update_count], 
						[sent_count], 
						[sent_seq], 
						[sent_date], 
						[sent_by], 
						[posted], 
						[posted2], 
						[posted3], 
						[posted4], 
						[posted5], 
						[plu_no], 
						[split_code], 
						[source_table], 
						[modifier1_id], 
						[modifier1_value], 
						[modifier1_op], 
						[modifier2_id], 
						[modifier2_value], 
						[modifier2_op], 
						[rush], 
						[pantry], 
						[order_ticket], 
						[bonus_redeem], 
						[splitrev_amount], 
						[nonsales_amount], 
						[nonsales], 
						[upload_status1], 
						[upload_status2], 
						[upload_status3], 
						[upload_status4], 
						[upload_status5], 
						[stock_flag], 
						[rush_count], 
						[rush_time_last], 
						[capture_systype], 
						[capture_systime], 
						[capture_reproc_req], 
						[capture_reproc_status], 
						[takeaway_mode]
					) VALUES (
						" . qv($shop_id) . ",
						" . qv($pos_id) . ",
						0,
						" . qv($data['tran_no']) . ",
						" . qv($data['tran_date']) . ",
						0,
						" . $data['seqno'] . ",
						" . $data['subtype'] . ",
						" . $data['link_row'] . ",
						0,
						'',
						0,
						" . qv($data['check_no']) . ",
						CURRENT_TIMESTAMP,
						0,
						" . $data['level_no'] . ",
						" . qv($record_item['item_code']) . ",
						" . qv($record_item['dept_id']) . ",
						" . qv($record_item['cat_id']) . ",
						" . qv($record_item['class_id']) . ",
						" . qv($this->q($record_item['pos_desc1'])) . ",
						" . qv($this->q($record_item['pos_desc2'])) . ",
						" . qv($data['qty']) . ",
						1,
						" . qv($record_item['unit']) . ",
						1,
						" . qv($price) . ",
						" . qv($amount) . ", 
						" . qv($record_item['discountable']) . ",
						" . qv($record_item['discid']) . ",
						" . qv($disc_type) . ",
						" . i($disc_rate) . ",
						" . $disc_amount . ",
						" . i($record_item['discid'] ? $data['empid'] : '') . ",
						NULL,
						NULL,
						NULL,
						" . qv($total_amount) . ",
						0,
						" . qv($record_item['service_allow']) . ",
						0,
						0,
						" . qv($record_item['taxable']) . ",
						NULL,
						0,
						0,
						" . qv($total_amount) . ",
						" . qv($data['empid']) . ",
						" . qv($shop_id) . ",
						" . qv($pos_id) . ",
						NULL,
						" . qv($record_item['is_modifier']) . ",
						NULL,
						" . qv($record_item['stock_code']) . ",
						0,
						0,
						0,
						0,
						0,
						0,
						NULL,
						" . qv($data['opendesc']) . ",
						0,
						0,
						CURRENT_TIMESTAMP,
						" . qv($data['empid']) . ",
						CURRENT_TIMESTAMP,
						" . qv($data['empid']) . ",
						1,
						0,
						0,
						NULL,
						NULL,
						0,
						0,
						0,
						0,
						0,
						" . qv($record_item['plu_no']) . ",
						NULL,
						" . qv($data['tableid']) . ",
						NULL,
						NULL,
						NULL,
						NULL,
						NULL,
						NULL,
						0,
						0,
						0,
						0,
						0,
						0,
						NULL,
						0,
						0,
						0,
						0,
						0,
						" . qv($record_item['stock_flag']) . ",
						0,
						NULL,
						1,
						CURRENT_TIMESTAMP,
						1,
						0,
						" . qv($data['istakeaway']) . "
					)";
		$this->SQL->query($sql);
		return array($record_item, $subtotal_amount, $chargeable, $taxable);
	}

	function sys_check_user($outletid = '', $empid = '', $emppw = '', $function = '')
	{
		$sql = "SELECT * FROM [user] WHERE [user_id]=" . qv($empid) . " AND [password]=" . qv($emppw) . " AND [shop_id]=" . qv($outletid) . " AND [enable]='1'";
		$record = $this->SQL->resultSingleArr($sql);
		$sql = "SELECT COUNT(*) FROM [user_rights] WHERE
					[shop_id]=" . qv($record['shop_id']) . " AND [id]=" . qv($record['group_id']) . " AND [id_type]='2' AND [rights1]='1' AND [function]=" . qv($function);
		$record_right = $this->SQL->resultValue($sql);
		return array($record_right, $record);
	}

	function sys_zip($files = array(), $destination = '', $overwrite = false)
	{
		if (file_exists($destination) && !$overwrite) return false;
		$valid_files = array();
		if (is_array($files)) foreach ($files as $file) if (file_exists($file)) $valid_files[] = $file;
		if (count($valid_files)) {
			$zip = new ZipArchive();
			if ($zip->open($destination, $overwrite ? ZIPARCHIVE::OVERWRITE : ZIPARCHIVE::CREATE) !== true) return false;
			foreach ($valid_files as $file) {
				$zip->addFile($file, basename($file));
			}
			$zip->close();
			return file_exists($destination);
		} else return false;
	}

	function sys_create_printer_txt($record = array())
	{
		$file = PRINTER_TXT_EXPORT . date("YmdHis") . i(current(explode(' ', microtime())) * 1000) . '_' . sprintf("%06d", PRESET_POS_ID);
		$this->sys_create_file("{$file}.tmp", $record);
		return rename("{$file}.tmp", "{$file}.txt");
	}

	function sys_create_csv($name = 'demo', $header = array(), $bank = array())
	{
		$bank = array_chunk($bank, 999);
		if (is_array($bank)) foreach ($bank as $i => $datas) {
			$i++;
			$record = stripslashes(implode(',', $header));
			if (is_array($datas)) foreach ($datas as $data) {
				$record .= "\n" . stripslashes(implode(',', str_replace(',', '/', $data)));
			}
			$record = str_replace('&amp;', '&', $record);
			$this->sys_create_file("csv/{$name}_{$i}.csv", $record);
		}
		return count($bank);
	}

	function sys_create_file($file = 'demo.txt', $data = '', $method = 'w')
	{
		if ($tmpFile = fopen($file, $method)) {
			fwrite($tmpFile, $data);
			fclose($tmpFile);
			return true;
		}
		return false;
	}

	function sys_price($price = 0)
	{
		return number_format($price, 2, '.', '');
	}
}
